/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch;

import com.floragunn.codova.config.temporal.DurationExpression;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.searchsupport.jobs.config.AbstractJobConfigFactory;
import com.floragunn.searchsupport.jobs.config.JobConfig;
import com.floragunn.searchsupport.jobs.config.schedule.DefaultScheduleFactory;
import com.floragunn.searchsupport.jobs.config.schedule.Schedule;
import com.floragunn.searchsupport.jobs.config.schedule.ScheduleFactory;
import com.floragunn.signals.NoSuchActionException;
import com.floragunn.signals.execution.WatchRunner;
import com.floragunn.signals.support.NestedValueMap;
import com.floragunn.signals.watch.action.handlers.AutoResolveActionHandler;
import com.floragunn.signals.watch.action.invokers.AlertAction;
import com.floragunn.signals.watch.action.invokers.AutoResolveAction;
import com.floragunn.signals.watch.action.invokers.ResolveAction;
import com.floragunn.signals.watch.checks.Check;
import com.floragunn.signals.watch.common.WatchElement;
import com.floragunn.signals.watch.init.WatchInitializationService;
import com.floragunn.signals.watch.severity.SeverityMapping;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.quartz.Job;
import org.quartz.JobKey;
import org.quartz.Trigger;

public class Watch
extends WatchElement
implements JobConfig,
ToXContentObject {
    private static final Logger log = LogManager.getLogger(Watch.class);
    public static Map<String, String> WITHOUT_AUTH_TOKEN_PARAM_MAP = Collections.singletonMap("include_auth_token", "false");
    public static final ToXContent.Params WITHOUT_AUTH_TOKEN = new ToXContent.MapParams(WITHOUT_AUTH_TOKEN_PARAM_MAP);
    public static final ToXContent.Params WITHOUT_META_AND_ACTIVE = new ToXContent.MapParams((Map)ImmutableMap.of((Object)"include_meta", (Object)"false", (Object)"include_active", (Object)"false"));
    private String tenant;
    private JobKey jobKey;
    private String description;
    private Class<? extends Job> jobClass = WatchRunner.class;
    private Map<String, Object> jobDataMap;
    private Schedule schedule;
    private List<Check> checks;
    private List<AlertAction> actions;
    private List<ResolveAction> resolveActions;
    private Map<String, Object> ui;
    protected DurationExpression throttlePeriod;
    private boolean active = true;
    private boolean logRuntimeData;
    private SeverityMapping severityMapping;
    private Meta meta = new Meta();
    private long version;

    public Watch() {
    }

    public Watch(JobKey jobKey, Schedule schedule, List<Check> checks, SeverityMapping severityMapping, List<AlertAction> actions, List<ResolveAction> resolveActions) {
        this.jobKey = jobKey;
        this.schedule = schedule;
        this.checks = checks;
        this.severityMapping = severityMapping;
        this.actions = actions;
        this.resolveActions = resolveActions;
    }

    public String getId() {
        return this.jobKey.getName();
    }

    public JobKey getJobKey() {
        return this.jobKey;
    }

    public String getDescription() {
        return this.description;
    }

    public Class<? extends Job> getJobClass() {
        return this.jobClass;
    }

    public Map<String, Object> getJobDataMap() {
        return this.jobDataMap;
    }

    public boolean isDurable() {
        return true;
    }

    public List<Trigger> getTriggers() {
        if (this.schedule != null) {
            return this.schedule.getTriggers();
        }
        return Collections.emptyList();
    }

    public List<Check> getChecks() {
        return this.checks;
    }

    public List<AlertAction> getActions() {
        return this.actions;
    }

    public AlertAction getActionByName(String name) throws NoSuchActionException {
        for (AlertAction action : this.actions) {
            if (!name.equals(action.getName())) continue;
            return action;
        }
        throw new NoSuchActionException(this.getId(), name);
    }

    public List<ResolveAction> getNonGeneratedResolveActions() {
        if (this.resolveActions == null || this.resolveActions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ResolveAction> result = new ArrayList<ResolveAction>(this.resolveActions.size());
        for (ResolveAction resolveAction : this.resolveActions) {
            if (resolveAction instanceof AutoResolveAction) continue;
            result.add(resolveAction);
        }
        return result;
    }

    public long getVersion() {
        return this.version;
    }

    public String toJson() {
        return Strings.toString((ToXContent)this);
    }

    public String toJsonWithoutAuthToken() {
        String string;
        block8: {
            XContentBuilder builder = JsonXContent.contentBuilder();
            try {
                this.toXContent(builder, WITHOUT_AUTH_TOKEN);
                string = BytesReference.bytes((XContentBuilder)builder).utf8ToString();
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            builder.close();
        }
        return string;
    }

    public String toJsonWithoutMetaAndActive() {
        String string;
        block8: {
            XContentBuilder builder = JsonXContent.contentBuilder();
            try {
                this.toXContent(builder, WITHOUT_META_AND_ACTIVE);
                string = BytesReference.bytes((XContentBuilder)builder).utf8ToString();
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            builder.close();
        }
        return string;
    }

    public String toString() {
        return this.jobKey.getName();
    }

    public int hashCode() {
        return this.jobKey.hashCode();
    }

    public String secureHash() {
        String json = this.toJsonWithoutMetaAndActive();
        return Hashing.sha256().hashString((CharSequence)json, StandardCharsets.UTF_8).toString();
    }

    public String getIdAndHash() {
        return this.getId() + "." + this.secureHash();
    }

    public String getSecureAuthTokenAudience() {
        return this.getIdAndHash();
    }

    private void initAutoResolveActions() {
        if (this.actions == null || this.actions.size() == 0) {
            return;
        }
        ArrayList<ResolveAction> newResolveActions = new ArrayList<ResolveAction>();
        if (this.resolveActions != null) {
            newResolveActions.addAll(this.resolveActions);
        }
        for (AlertAction action : this.actions) {
            if (!(action.getHandler() instanceof AutoResolveActionHandler) || !((AutoResolveActionHandler)((Object)action.getHandler())).isAutoResolveEnabled()) continue;
            newResolveActions.add(new AutoResolveAction(action, ((AutoResolveActionHandler)((Object)action.getHandler())).getResolveActionHandler()));
        }
        this.resolveActions = newResolveActions;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.tenant != null) {
            builder.field("_tenant", this.tenant);
        }
        if (this.schedule != null) {
            builder.field("trigger");
            builder.startObject();
            builder.field("schedule", (ToXContent)this.schedule);
            builder.endObject();
        }
        if (this.throttlePeriod != null) {
            builder.field("throttle_period", this.throttlePeriod.toString());
        }
        builder.field("checks").startArray();
        for (Check check : this.checks) {
            check.toXContent(builder, params);
        }
        builder.endArray();
        if (this.severityMapping != null) {
            builder.field("severity");
            this.severityMapping.toXContent(builder, params);
        }
        builder.field("actions").startArray();
        for (AlertAction action : this.actions) {
            action.toXContent(builder, params);
        }
        builder.endArray();
        List<ResolveAction> resolveActions = this.getNonGeneratedResolveActions();
        if (resolveActions != null && resolveActions.size() > 0) {
            builder.field("resolve_actions").startArray();
            for (ResolveAction action : resolveActions) {
                action.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (params.paramAsBoolean("include_active", true)) {
            builder.field("active", this.active);
        }
        builder.field("log_runtime_data", this.logRuntimeData);
        if (params.paramAsBoolean("include_meta", true)) {
            builder.field("_meta");
            this.meta.toXContent(builder, params);
        }
        if (this.ui != null && this.ui.size() > 0) {
            builder.field("_ui", this.ui);
        }
        builder.endObject();
        return builder;
    }

    public DurationExpression getThrottlePeriod() {
        return this.throttlePeriod;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isLogRuntimeData() {
        return this.logRuntimeData;
    }

    public void setLogRuntimeData(boolean logRuntimeData) {
        this.logRuntimeData = logRuntimeData;
    }

    public Map<String, Object> getUi() {
        return this.ui;
    }

    public void setUi(Map<String, Object> ui) {
        this.ui = ui;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public SeverityMapping getSeverityMapping() {
        return this.severityMapping;
    }

    public void setSeverityMapping(SeverityMapping severityMapping) {
        this.severityMapping = severityMapping;
    }

    public List<ResolveAction> getResolveActions() {
        return this.resolveActions;
    }

    public void setResolveActions(List<ResolveAction> resolveActions) {
        this.resolveActions = resolveActions;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public String getAuthToken() {
        return this.meta.authToken;
    }

    public Schedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(Schedule schedule) {
        this.schedule = schedule;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static Watch parse(WatchInitializationService ctx, String tenant, String id, String json, long version) throws ConfigValidationException {
        return Watch.parse(ctx, tenant, id, DocNode.parse((Format)Format.JSON).from(json), version);
    }

    public static Watch parseFromElasticDocument(WatchInitializationService ctx, String tenant, String id, String json, long version) throws ConfigValidationException {
        DocNode jsonNode = DocNode.parse((Format)Format.JSON).from(json);
        if (jsonNode.hasNonNull("_source")) {
            return Watch.parse(ctx, tenant, id, jsonNode.getAsNode("_source"), version);
        }
        throw new ConfigValidationException((ValidationError)new MissingAttribute("_source", (Object)jsonNode));
    }

    public static Watch parse(WatchInitializationService ctx, String tenant, String id, DocNode jsonNode) throws ConfigValidationException {
        return Watch.parse(ctx, tenant, id, jsonNode, -1L);
    }

    public static Watch parse(WatchInitializationService ctx, String tenant, String id, DocNode jsonNode, long version) throws ConfigValidationException {
        JobKey jobKey;
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonNode, validationErrors);
        boolean severityHasErrors = false;
        vJsonNode.used(new String[]{"trigger", "_tenant", "_name"});
        Watch result = new Watch();
        result.jobKey = jobKey = Watch.createJobKey(id);
        result.tenant = tenant;
        if (vJsonNode.hasNonNull("description")) {
            result.description = vJsonNode.get("description").asString();
        }
        result.schedule = (Schedule)vJsonNode.get("trigger").by(triggerNode -> DefaultScheduleFactory.INSTANCE.create(jobKey, triggerNode));
        try {
            result.checks = vJsonNode.get("inputs").asAnything() instanceof List ? Check.create(ctx, (List)jsonNode.get("inputs")) : (vJsonNode.get("checks").asAnything() instanceof List ? Check.create(ctx, (List)jsonNode.get("checks")) : Collections.emptyList());
        }
        catch (ConfigValidationException e) {
            validationErrors.add("checks", e);
        }
        try {
            if (vJsonNode.hasNonNull("severity")) {
                result.severityMapping = SeverityMapping.create(ctx, jsonNode.getAsNode("severity"));
            }
        }
        catch (ConfigValidationException e) {
            validationErrors.add("severity", e);
            severityHasErrors = true;
        }
        try {
            result.actions = vJsonNode.hasNonNull("actions") ? AlertAction.createFromArray(ctx, (List<DocNode>)jsonNode.getAsListOfNodes("actions"), !severityHasErrors ? result.severityMapping : SeverityMapping.DUMMY_MAPPING) : Collections.emptyList();
        }
        catch (ConfigValidationException e) {
            validationErrors.add("actions", e);
        }
        try {
            result.resolveActions = vJsonNode.hasNonNull("resolve_actions") ? ResolveAction.createFromArray(ctx, (List<DocNode>)jsonNode.getAsListOfNodes("resolve_actions"), !severityHasErrors ? result.severityMapping : SeverityMapping.DUMMY_MAPPING) : Collections.emptyList();
        }
        catch (ConfigValidationException e) {
            validationErrors.add("resolve_actions", e);
        }
        result.throttlePeriod = (DurationExpression)vJsonNode.get("throttle_period").byString(DurationExpression::parse);
        result.active = vJsonNode.hasNonNull("active") ? vJsonNode.get("active").asBoolean() : true;
        result.logRuntimeData = vJsonNode.hasNonNull("log_runtime_data") ? vJsonNode.get("log_runtime_data").asBoolean() : false;
        result.initAutoResolveActions();
        result.version = version;
        if (vJsonNode.hasNonNull("_meta")) {
            result.meta = Meta.parseMeta(vJsonNode.get("_meta").asDocNode());
        }
        if (vJsonNode.hasNonNull("_ui")) {
            result.ui = vJsonNode.get("_ui").asMap();
        }
        vJsonNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        return result;
    }

    public static JobKey createJobKey(String id) {
        return new JobKey(id, "lrt");
    }

    public static Map<String, Object> getIndexMapping() {
        NestedValueMap result = new NestedValueMap();
        result.put("dynamic", (Object)true);
        result.put(new NestedValueMap.Path("properties", "checks"), (Object)Check.getIndexMapping());
        result.put(new NestedValueMap.Path("properties", "_tenant", "type"), (Object)"text");
        result.put(new NestedValueMap.Path("properties", "_tenant", "analyzer"), (Object)"keyword");
        result.put(new NestedValueMap.Path("properties", "actions", "dynamic"), (Object)true);
        result.put(new NestedValueMap.Path("properties", "actions", "properties", "checks"), (Object)Check.getIndexMapping());
        return result;
    }

    public static Map<String, Object> getIndexMappingUpdate() {
        NestedValueMap result = new NestedValueMap();
        result.put("dynamic", (Object)true);
        result.put(new NestedValueMap.Path("properties", "checks"), (Object)Check.getIndexMappingUpdate());
        result.put(new NestedValueMap.Path("properties", "actions", "properties", "checks"), (Object)Check.getIndexMappingUpdate());
        return result;
    }

    public void setThrottlePeriod(DurationExpression throttlePeriod) {
        this.throttlePeriod = throttlePeriod;
    }

    public static class HiddenAttributes {
        public static final List<String> LIST = Arrays.asList("_meta.auth_token", "_name");
        public static final FetchSourceContext FETCH_SOURCE_CONTEXT = new FetchSourceContext(true, Strings.EMPTY_ARRAY, HiddenAttributes.asArray());

        public static String[] asArray() {
            return LIST.toArray(new String[LIST.size()]);
        }
    }

    public static class JobConfigFactory
    extends AbstractJobConfigFactory<Watch> {
        private final WatchInitializationService initContext;
        private final String tenantIdPrefix;
        private final String tenant;

        public JobConfigFactory(String tenant, String tenantIdPrefix, WatchInitializationService initContext) {
            super(WatchRunner.class, (ScheduleFactory)DefaultScheduleFactory.INSTANCE);
            this.initContext = initContext;
            this.tenant = tenant;
            this.tenantIdPrefix = tenantIdPrefix;
        }

        protected Watch createFromJsonNode(String id, DocNode jsonNode, long version) throws ConfigValidationException {
            String tenant = jsonNode.getAsString("_tenant");
            if (this.tenant != null && !this.tenant.equals(tenant)) {
                throw new IllegalStateException("Watch " + id + " has unexpected tenant: " + tenant + "; expected: " + this.tenant);
            }
            String watchId = this.getWatchId(id);
            return Watch.parse(this.initContext, tenant, watchId, jsonNode, version);
        }

        protected JobKey getJobKey(String id, DocNode jsonNode) {
            return Watch.createJobKey(this.getWatchId(id));
        }

        private String getWatchId(String id) {
            if (this.tenantIdPrefix != null && !id.startsWith(this.tenantIdPrefix)) {
                throw new IllegalStateException("Watch " + id + " has unexpected tenant prefix in id: " + id + "; expected: " + this.tenantIdPrefix);
            }
            return id.substring(this.tenantIdPrefix.length());
        }
    }

    public static class Meta
    implements ToXContentObject {
        private String authToken;
        private String lastEditByUser;
        private Date lastEditByDate;

        static Meta parseMeta(DocNode metaNode) {
            Meta result = new Meta();
            if (metaNode.hasNonNull("auth_token")) {
                result.authToken = metaNode.getAsString("auth_token");
            }
            if (metaNode.hasNonNull("last_edit")) {
                DocNode lastEditNode = metaNode.getAsNode("last_edit");
                if (lastEditNode.hasNonNull("user")) {
                    result.lastEditByUser = lastEditNode.getAsString("user");
                }
                if (lastEditNode.hasNonNull("date")) {
                    try {
                        result.lastEditByDate = Date.from(ZonedDateTime.from(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.parse(lastEditNode.getAsString("date"))).toInstant());
                    }
                    catch (Exception e) {
                        log.warn("Error while parsing last edit date: " + lastEditNode + " for " + result, (Throwable)e);
                    }
                }
            }
            return result;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (params.paramAsBoolean("include_auth_token", true) && this.authToken != null) {
                builder.field("auth_token", this.authToken);
            }
            if (this.lastEditByUser != null) {
                builder.startObject("last_edit");
                builder.field("user", this.lastEditByUser);
                builder.field("date", (Object)this.lastEditByDate);
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        public Map<String, Object> toMap() throws IOException {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            if (this.authToken != null) {
                result.put("auth_token", this.authToken);
            }
            if (this.lastEditByUser != null) {
                result.put("last_edit", ImmutableMap.of((Object)"user", (Object)this.lastEditByUser, (Object)"date", (Object)this.lastEditByDate));
            }
            return result;
        }

        public String getAuthToken() {
            return this.authToken;
        }

        public void setAuthToken(String authToken) {
            this.authToken = authToken;
        }

        public String getLastEditByUser() {
            return this.lastEditByUser;
        }

        public void setLastEditByUser(String lastEditByUser) {
            this.lastEditByUser = lastEditByUser;
        }

        public Date getLastEditByDate() {
            return this.lastEditByDate;
        }

        public void setLastEditByDate(Date lastEditByDate) {
            this.lastEditByDate = lastEditByDate;
        }
    }
}

